<?php

	$routes[] = array('project_open_issues', '/:project_key/issues/open/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_OPEN_ISSUES, 'search' => true));
	$routes[] = array('project_closed_issues', '/:project_key/issues/closed/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_CLOSED_ISSUES, 'search' => true));
	$routes[] = array('project_wishlist_issues', '/:project_key/issues/wishlist/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_WISHLIST, 'search' => true));
	$routes[] = array('project_milestone_todo_list', '/:project_key/issues/todo/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_MILESTONE_TODO, 'search' => true));
	$routes[] = array('project_most_voted_issues', '/:project_key/issues/mostvoted/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_MOST_VOTED, 'search' => true));
	$routes[] = array('project_month_issues', '/:project_key/issues/this/month/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_REPORTED_THIS_MONTH, 'search' => true));
	$routes[] = array('project_last_issues', '/:project_key/issues/last/:units/:time_unit/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_PROJECT_REPORTED_LAST_NUMBEROF_TIMEUNITS, 'search' => true));
	$routes[] = array('project_my_teams_assigned_issues', '/:project_key/issues/my/assigned/teams', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_TEAM_ASSIGNED_OPEN_ISSUES, 'search' => true));
	$routes[] = array('project_my_assigned_issues', '/:project_key/issues/my/assigned/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_MY_ASSIGNED_OPEN_ISSUES, 'search' => true));
	$routes[] = array('project_my_owned_issues', '/:project_key/issues/my/owned/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_MY_OWNED_OPEN_ISSUES, 'search' => true));
	$routes[] = array('project_my_reported_issues', '/:project_key/issues/my/*', 'search', 'findIssues', array('predefined_search' => TBGContext::PREDEFINED_SEARCH_MY_REPORTED_ISSUES, 'search' => true));
	$routes[] = array('viewissue_find_issue', '/:project_key/findissues/:issue_id/:type', 'main', 'findIssue', array('format' => 'json'));
	$routes[] = array('viewissue_relate_issues', '/:project_key/issues/:issue_id/relate', 'main', 'relateIssues', array('format' => 'json'));
	$routes[] = array('viewissue_remove_related_issue', '/:project_key/issues/:issue_id/remove/related/issue/:related_issue_id', 'main', 'removeRelatedIssue');
	$routes[] = array('viewissue_related_issues', '/:project_key/issues/:issue_id/related', 'main', 'relatedIssues');
	$routes[] = array('deleteissue', '/:project_key/issues/:issue_id/delete', 'main', 'deleteIssue');
	$routes[] = array('lock_issue', '/lock/issue/:issue_id', 'main', 'lockIssue');
	$routes[] = array('unlock_issue', '/unlock/issue/:issue_id', 'main', 'unlockIssue');
	$routes[] = array('block', '/:project_key/issues/:issue_id/block', 'main', 'markAsBlocker');
	$routes[] = array('unblock', '/:project_key/issues/:issue_id/unblock', 'main', 'markAsNotBlocker');
	$routes[] = array('issue_gettempfieldvalue', '/get/temp/value/for/:field/*', 'main', 'issueGetTempFieldValue');
	$routes[] = array('issue_setfield', '/:project_key/issues/:issue_id/set/:field/*', 'main', 'issueSetField');
	$routes[] = array('issue_revertfield', '/:project_key/issues/:issue_id/revert/:field', 'main', 'issueRevertField');
	$routes[] = array('getacl_formentry', '/get/acl/formentry/for/:identifiable_type/:identifiable_value', 'main', 'getACLFormEntry');
	$routes[] = array('main_find_identifiable', '/find/identifiable/by/*', 'main', 'findIdentifiable');
	$routes[] = array('toggle_favourite_issue', '/toggle_favourite_issue/:issue_id', 'main', 'toggleFavouriteIssue', array('format' => 'json'));
	$routes[] = array('project_getmenulinks', '/:project_key/menulinks', 'project', 'menuLinks');
//	$routes[] = array('project_reportissue', '/:project_key/issues/new/:issuetype/*', 'main', 'reportIssue');
	$routes[] = array('project_reportissue', '/:project_key/issues/new/*', 'main', 'reportIssue');
	$routes[] = array('transition_issue', '/:project_key/:issue_id/transition/:transition_id', 'project', 'transitionIssue');
	$routes[] = array('transition_issues', '/:project_key/transition/:transition_id', 'project', 'transitionIssues');
	$routes[] = array('project_planning', '/:project_key/planning', 'project', 'planning');
	$routes[] = array('project_milestone', '/:project_key/milestone', 'project', 'milestone');
	$routes[] = array('project_settings', '/:project_key/settings', 'project', 'settings');
	$routes[] = array('project_create_role', '/:project_key/roles/new', 'project', 'addRole');
	$routes[] = array('project_releases', '/:project_key/releases', 'project', 'releases');
	$routes[] = array('project_release_center', '/:project_key/release_center', 'project', 'releaseCenter');
	$routes[] = array('project_milestone_details', '/:project_key/milestone/:milestone_id/details/*', 'project', 'milestoneDetails');
	$routes[] = array('project_scrum_release_burndown', '/:project_key/scrum/burndown/release', 'project', 'scrumShowBurndown', array('mode' => 'release'));
	$routes[] = array('project_scrum_sprint_burndown_image', '/:project_key/scrum/burndown/sprint/image/*', 'project', 'scrumShowBurndownImage', array('mode' => 'sprint'));
	$routes[] = array('project_scrum_release_burndown_image', '/:project_key/scrum/burndown/release/image/*', 'project', 'scrumShowBurndownImage', array('mode' => 'release'));
	$routes[] = array('project_scrum_assign_story', '/:project_key/scrum/assign/story', 'project', 'scrumAssignStory');
	$routes[] = array('project_scrum_add_sprint', '/:project_key/scrum/add/sprint', 'project', 'scrumAddSprint');
	$routes[] = array('project_scrum_story_setcolor', '/:project_key/scrum/set/color/for/story/:story_id', 'project', 'scrumSetStoryDetail', array('detail' => 'color'));
	$routes[] = array('project_scrum_story_setestimates', '/:project_key/scrum/set/estimates/for/story/:story_id', 'project', 'scrumSetStoryDetail', array('detail' => 'estimates'));
	$routes[] = array('project_scrum_story_addtask', '/:project_key/scrum/add/task/for/story/:story_id/*', 'project', 'scrumAddTask');
	$routes[] = array('project_search_paginated', '/:project_key/issues/paginated/*', 'search', 'findIssuesPaginated');
	$routes[] = array('project_search_add_filter', '/:project_key/issues/add/filter/*', 'search', 'addFilter');
	$routes[] = array('project_issues', '/:project_key/issues/find/*', 'search', 'findIssues');
	$routes[] = array('viewissue', '/:project_key/issues/:issue_no/*', 'main', 'viewIssue');
	$routes[] = array('project_quicksearch', '/:project_key/quicksearch/*', 'search', 'findIssues', array('quicksearch' => true, 'issues_per_page' => 6));
	$routes[] = array('project_opensearch', '/:project_key/opensearch.xml', 'search', 'opensearch', array('format' => 'xml'));
	$routes[] = array('project_team', '/:project_key/team', 'project', 'team');
	$routes[] = array('project_statistics', '/:project_key/statistics', 'project', 'statistics');
	$routes[] = array('project_statistics_last_15', '/:project_key/statistics/last/15', 'project', 'statisticsLast15');
	$routes[] = array('project_statistics_imagesets', '/:project_key/statistics/imagesets/:set', 'project', 'statisticsImagesets');
	$routes[] = array('project_statistics_image', '/:project_key/statistics/image/:key/:mode/:image_number/*', 'project', 'statisticsGetImage');
	$routes[] = array('project_timeline', '/:project_key/timeline/*', 'project', 'timeline');
	$routes[] = array('project_timeline_important', '/:project_key/timeline/show/important/*', 'project', 'timeline');
	$routes[] = array('project_files', '/:project_key/files', 'project', 'files');
	$routes[] = array('project_planning_milestone', '/:project_key/planning/milestone/:milestone_id', 'project', 'getMilestone');
	$routes[] = array('project_planning_milestone_remove', '/:project_key/planning/milestone/:milestone_id/remove', 'project', 'removeMilestone');
	$routes[] = array('project_planning_milestone_issues', '/:project_key/planning/milestone/:milestone_id/get/issues', 'project', 'getMilestoneIssues', array('mode' => 'planning'));
	$routes[] = array('project_planning_update_milestone_issues', '/:project_key/planning/milestone/:milestone_id/update/issues', 'project', 'updateMilestoneIssues');
	$routes[] = array('project_planning_save_column_settings', '/:project_key/planning/save/columnsettings', 'project', 'savePlanningColumnSettings');
	$routes[] = array('project_roadmap', '/:project_key/roadmap', 'project', 'roadmap');
	$routes[] = array('project_roadmap_milestone_issues', '/:project_key/milestone/:milestone_id/get/issues', 'project', 'getMilestoneIssues');
	$routes[] = array('project_roadmap_milestone_refresh', '/:project_key/milestone/:milestone_id/get/details', 'project', 'getMilestoneDetails');
	$routes[] = array('project_list_issues', '/:project_key/list/issues/:format/*', 'project', 'listIssues');
	$routes[] = array('project_list_issuefields', '/:project_key/list/issuefields/for/type/:issuetype/:format', 'project', 'listIssuefields');
	$routes[] = array('project_update_issuedetails', '/:project_key/update/issue/:issue_no/:format/*', 'project', 'updateIssueDetails');
	$routes[] = array('project_list_workflowtransitions', '/:project_key/list/workflowtransitions/:issue_no/:format/*', 'project', 'listWorkflowTransitions');
	$routes[] = array('project_dashboard', '/:project_key', 'project', 'dashboard');

	foreach ($routes as $route)
	{
		call_user_func_array(array(TBGContext::getRouting(), 'addRoute'), $route);
	}
